/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.ValueGetter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.filter.BooleanValueMatcher;

public class LongValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<BaseLongColumnValueSelector> {
    @Override
    public ValueMatcher makeValueMatcher(final BaseLongColumnValueSelector selector, String value) {
        Long matchVal = DimensionHandlerUtils.convertObjectToLong(value);
        if (matchVal == null) {
            return BooleanValueMatcher.of(false);
        }
        final long matchValLong = matchVal;
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return selector.getLong() == matchValLong;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final BaseLongColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidLongPredicate predicate = predicateFactory.makeLongPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.applyLong(selector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueGetter makeValueGetter(final BaseLongColumnValueSelector selector) {
        return new ValueGetter(){

            @Override
            public String[] get() {
                return new String[]{Long.toString(selector.getLong())};
            }
        };
    }
}

