/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import io.druid.query.filter.DruidFloatPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.ValueGetter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseFloatColumnValueSelector;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.filter.BooleanValueMatcher;

public class FloatValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<BaseFloatColumnValueSelector> {
    @Override
    public ValueMatcher makeValueMatcher(final BaseFloatColumnValueSelector selector, String value) {
        Float matchVal = DimensionHandlerUtils.convertObjectToFloat(value);
        if (matchVal == null) {
            return BooleanValueMatcher.of(false);
        }
        final int matchValIntBits = Float.floatToIntBits(matchVal.floatValue());
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Float.floatToIntBits(selector.getFloat()) == matchValIntBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final BaseFloatColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidFloatPredicate predicate = predicateFactory.makeFloatPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.applyFloat(selector.getFloat());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueGetter makeValueGetter(final BaseFloatColumnValueSelector selector) {
        return new ValueGetter(){

            @Override
            public String[] get() {
                return new String[]{Float.toString(selector.getFloat())};
            }
        };
    }
}

