/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import io.druid.java.util.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.Filter;
import io.druid.query.filter.SelectorDimFilter;
import java.nio.ByteBuffer;

@Deprecated
public class ExtractionDimFilter
implements DimFilter {
    private final String dimension;
    private final String value;
    private final ExtractionFn extractionFn;

    @JsonCreator
    public ExtractionDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @Deprecated @JsonProperty(value="dimExtractionFn") ExtractionFn dimExtractionFn) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((extractionFn != null || dimExtractionFn != null ? 1 : 0) != 0, (Object)"extraction function must not be null");
        this.dimension = dimension;
        this.value = value;
        this.extractionFn = extractionFn != null ? extractionFn : dimExtractionFn;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] valueBytes = this.value == null ? new byte[]{} : StringUtils.toUtf8((String)this.value);
        byte[] extractionFnBytes = this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + valueBytes.length + extractionFnBytes.length).put((byte)4).put(dimensionBytes).put((byte)-1).put(valueBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return new SelectorDimFilter(this.dimension, this.value, this.extractionFn).optimize();
    }

    @Override
    public Filter toFilter() {
        return new SelectorDimFilter(this.dimension, this.value, this.extractionFn).toFilter();
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    public String toString() {
        return StringUtils.format((String)"%s(%s) = %s", (Object[])new Object[]{this.extractionFn, this.dimension, this.value});
    }
}

