/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.RangeSet;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprMacroTable;
import io.druid.math.expr.Parser;
import io.druid.query.cache.CacheKeyBuilder;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.Filter;
import io.druid.segment.filter.ExpressionFilter;
import java.util.Objects;

public class ExpressionDimFilter
implements DimFilter {
    private final String expression;
    private final Expr parsed;

    @JsonCreator
    public ExpressionDimFilter(@JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        this.expression = expression;
        this.parsed = Parser.parse((String)expression, (ExprMacroTable)macroTable);
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new ExpressionFilter(this.parsed);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(14).appendString(this.expression).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionDimFilter that = (ExpressionDimFilter)o;
        return Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }

    public String toString() {
        return "ExpressionDimFilter{expression='" + this.expression + '\'' + '}';
    }
}

