/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import io.druid.query.filter.DruidDoublePredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.ValueGetter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseDoubleColumnValueSelector;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.filter.BooleanValueMatcher;

public class DoubleValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<BaseDoubleColumnValueSelector> {
    @Override
    public ValueMatcher makeValueMatcher(final BaseDoubleColumnValueSelector selector, String value) {
        Double matchVal = DimensionHandlerUtils.convertObjectToDouble(value);
        if (matchVal == null) {
            return BooleanValueMatcher.of(false);
        }
        final long matchValLongBits = Double.doubleToLongBits(matchVal);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Double.doubleToLongBits(selector.getDouble()) == matchValLongBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final BaseDoubleColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidDoublePredicate predicate = predicateFactory.makeDoublePredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.applyDouble(selector.getDouble());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueGetter makeValueGetter(final BaseDoubleColumnValueSelector selector) {
        return new ValueGetter(){

            @Override
            public String[] get() {
                return new String[]{Double.toString(selector.getDouble())};
            }
        };
    }
}

