/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import java.util.Arrays;
import java.util.List;

public class DimFilters {
    public static SelectorDimFilter dimEquals(String dimension, String value) {
        return new SelectorDimFilter(dimension, value, null);
    }

    public static AndDimFilter and(DimFilter ... filters) {
        return DimFilters.and(Arrays.asList(filters));
    }

    public static AndDimFilter and(List<DimFilter> filters) {
        return new AndDimFilter(filters);
    }

    public static OrDimFilter or(DimFilter ... filters) {
        return DimFilters.or(Arrays.asList(filters));
    }

    public static OrDimFilter or(List<DimFilter> filters) {
        return new OrDimFilter(filters);
    }

    public static NotDimFilter not(DimFilter filter) {
        return new NotDimFilter(filter);
    }

    public static List<DimFilter> optimize(List<DimFilter> filters) {
        return DimFilters.filterNulls(Lists.transform(filters, (Function)new Function<DimFilter, DimFilter>(){

            public DimFilter apply(DimFilter input) {
                return input.optimize();
            }
        }));
    }

    public static List<DimFilter> filterNulls(List<DimFilter> optimized) {
        return Lists.newArrayList((Iterable)Iterables.filter(optimized, (Predicate)Predicates.notNull()));
    }
}

