/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import io.druid.query.cache.CacheKeyBuilder;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.Filter;
import io.druid.segment.filter.ColumnComparisonFilter;
import java.util.List;

public class ColumnComparisonDimFilter
implements DimFilter {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private final List<DimensionSpec> dimensions;

    @JsonCreator
    public ColumnComparisonDimFilter(@JsonProperty(value="dimensions") List<DimensionSpec> dimensions) {
        this.dimensions = (List)Preconditions.checkNotNull(dimensions, (Object)"dimensions");
        Preconditions.checkArgument((dimensions.size() >= 2 ? 1 : 0) != 0, (Object)"dimensions must have a least 2 dimensions");
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(13).appendCacheablesIgnoringOrder(this.dimensions).build();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new ColumnComparisonFilter(this.dimensions);
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return "ColumnComparisonDimFilter{dimensions=[" + COMMA_JOINER.join(this.dimensions) + "]}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnComparisonDimFilter that = (ColumnComparisonDimFilter)o;
        return this.dimensions.equals(that.dimensions);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    public int hashCode() {
        return 31 * this.dimensions.hashCode();
    }
}

