/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import javax.annotation.Nullable;

public class StrlenExtractionFn
extends DimExtractionFn {
    private static final StrlenExtractionFn INSTANCE = new StrlenExtractionFn();

    private StrlenExtractionFn() {
    }

    @JsonCreator
    public static StrlenExtractionFn instance() {
        return INSTANCE;
    }

    @Override
    public String apply(@Nullable String value) {
        return String.valueOf(value == null ? 0 : value.length());
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public byte[] getCacheKey() {
        return new byte[]{14};
    }
}

