/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Strings;
import io.druid.java.util.common.StringUtils;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;

@JsonTypeName(value="lower")
public class LowerExtractionFn
extends DimExtractionFn {
    private final Locale locale;
    @JsonProperty
    private final String localeString;

    public LowerExtractionFn(@JsonProperty(value="locale") String localeString) {
        this.localeString = localeString;
        this.locale = localeString == null ? Locale.getDefault() : Locale.forLanguageTag(localeString);
    }

    @Override
    @Nullable
    public String apply(@Nullable String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        return key.toLowerCase(this.locale);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public byte[] getCacheKey() {
        byte[] localeBytes = StringUtils.toUtf8((String)Strings.nullToEmpty((String)this.localeString));
        return ByteBuffer.allocate(2 + localeBytes.length).put((byte)12).put((byte)-1).put(localeBytes).array();
    }
}

