/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import io.druid.query.extraction.ExtractionFn;
import java.util.Arrays;
import javax.annotation.Nullable;

public class CascadeExtractionFn
implements ExtractionFn {
    private final ExtractionFn[] extractionFns;
    private final ChainedExtractionFn chainedExtractionFn;
    private final ChainedExtractionFn DEFAULT_CHAINED_EXTRACTION_FN = new ChainedExtractionFn(new ExtractionFn(){

        public byte[] getCacheKey() {
            return new byte[0];
        }

        @Override
        @Nullable
        public String apply(@Nullable Object value) {
            return null;
        }

        @Override
        @Nullable
        public String apply(@Nullable String value) {
            return null;
        }

        @Override
        public String apply(long value) {
            return null;
        }

        @Override
        public boolean preservesOrdering() {
            return false;
        }

        @Override
        public ExtractionFn.ExtractionType getExtractionType() {
            return ExtractionFn.ExtractionType.MANY_TO_ONE;
        }

        public String toString() {
            return "nullExtractionFn{}";
        }
    }, null);

    @JsonCreator
    public CascadeExtractionFn(@JsonProperty(value="extractionFns") ExtractionFn[] extractionFn) {
        Preconditions.checkArgument((extractionFn != null ? 1 : 0) != 0, (Object)"extractionFns should not be null");
        this.extractionFns = extractionFn;
        if (this.extractionFns.length == 0) {
            this.chainedExtractionFn = this.DEFAULT_CHAINED_EXTRACTION_FN;
        } else {
            ChainedExtractionFn root = null;
            for (ExtractionFn fn : extractionFn) {
                Preconditions.checkArgument((fn != null ? 1 : 0) != 0, (Object)"empty function is not allowed");
                root = new ChainedExtractionFn(fn, root);
            }
            this.chainedExtractionFn = root;
        }
    }

    @JsonProperty
    public ExtractionFn[] getExtractionFns() {
        return this.extractionFns;
    }

    public byte[] getCacheKey() {
        byte[] cacheKey = new byte[]{9};
        return Bytes.concat((byte[][])new byte[][]{cacheKey, this.chainedExtractionFn.getCacheKey()});
    }

    @Override
    @Nullable
    public String apply(@Nullable Object value) {
        return this.chainedExtractionFn.apply(value);
    }

    @Override
    @Nullable
    public String apply(@Nullable String value) {
        return this.chainedExtractionFn.apply(value);
    }

    @Override
    public String apply(long value) {
        return this.chainedExtractionFn.apply(value);
    }

    @Override
    public boolean preservesOrdering() {
        return this.chainedExtractionFn.preservesOrdering();
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.chainedExtractionFn.getExtractionType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CascadeExtractionFn that = (CascadeExtractionFn)o;
        if (!Arrays.equals(this.extractionFns, that.extractionFns)) {
            return false;
        }
        return this.chainedExtractionFn.equals(that.chainedExtractionFn);
    }

    public int hashCode() {
        return this.chainedExtractionFn.hashCode();
    }

    public String toString() {
        return "CascadeExtractionFn{extractionFns=[" + this.chainedExtractionFn.toString() + "]}";
    }

    private static class ChainedExtractionFn {
        private final ExtractionFn fn;
        private final ChainedExtractionFn child;

        public ChainedExtractionFn(ExtractionFn fn, ChainedExtractionFn child) {
            this.fn = fn;
            this.child = child;
        }

        public byte[] getCacheKey() {
            byte[] fnCacheKey = this.fn.getCacheKey();
            return this.child != null ? Bytes.concat((byte[][])new byte[][]{fnCacheKey, this.child.getCacheKey()}) : fnCacheKey;
        }

        @Nullable
        public String apply(@Nullable Object value) {
            return this.fn.apply(this.child != null ? this.child.apply(value) : value);
        }

        @Nullable
        public String apply(@Nullable String value) {
            return this.fn.apply(this.child != null ? this.child.apply(value) : value);
        }

        public String apply(long value) {
            return this.fn.apply(this.child != null ? this.child.apply(value) : Long.valueOf(value));
        }

        public boolean preservesOrdering() {
            boolean childPreservesOrdering = this.child == null || this.child.preservesOrdering();
            return this.fn.preservesOrdering() && childPreservesOrdering;
        }

        public ExtractionFn.ExtractionType getExtractionType() {
            if (this.child != null && this.child.getExtractionType() == ExtractionFn.ExtractionType.MANY_TO_ONE) {
                return ExtractionFn.ExtractionType.MANY_TO_ONE;
            }
            return this.fn.getExtractionType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChainedExtractionFn that = (ChainedExtractionFn)o;
            if (!this.fn.equals(that.fn)) {
                return false;
            }
            return this.child == null || this.child.equals(that.child);
        }

        public int hashCode() {
            int result = this.fn.hashCode();
            if (this.child != null) {
                result = 31 * result + this.child.hashCode();
            }
            return result;
        }

        public String toString() {
            return this.child != null ? Joiner.on((String)",").join((Object)this.child.toString(), (Object)this.fn.toString(), new Object[0]) : this.fn.toString();
        }
    }
}

