/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.expression;

import io.druid.java.util.common.IAE;
import io.druid.java.util.common.granularity.PeriodGranularity;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.expression.ExprUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;

public class TimestampShiftExprMacro
implements ExprMacroTable.ExprMacro {
    public String name() {
        return "timestamp_shift";
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 3 || args.size() > 4) {
            throw new IAE("Function[%s] must have 3 to 4 arguments", new Object[]{this.name()});
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampShiftExpr(args);
        }
        return new TimestampShiftDynamicExpr(args);
    }

    private static PeriodGranularity getGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    private static int getStep(List<Expr> args, Expr.ObjectBinding bindings) {
        return args.get(2).eval(bindings).asInt();
    }

    private static class TimestampShiftDynamicExpr
    implements Expr {
        private final List<Expr> args;

        public TimestampShiftDynamicExpr(List<Expr> args) {
            this.args = args;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampShiftExprMacro.getGranularity(this.args, bindings);
            Period period = granularity.getPeriod();
            ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)granularity.getTimeZone());
            int step = TimestampShiftExprMacro.getStep(this.args, bindings);
            return ExprEval.of((long)chronology.add((ReadablePeriod)period, this.args.get(0).eval(bindings).asLong(), step));
        }

        public void visit(Expr.Visitor visitor) {
            for (Expr arg : this.args) {
                arg.visit(visitor);
            }
            visitor.visit((Expr)this);
        }
    }

    private static class TimestampShiftExpr
    implements Expr {
        private final Expr arg;
        private final Chronology chronology;
        private final Period period;
        private final int step;

        public TimestampShiftExpr(List<Expr> args) {
            PeriodGranularity granularity = TimestampShiftExprMacro.getGranularity(args, ExprUtils.nilBindings());
            this.arg = args.get(0);
            this.period = granularity.getPeriod();
            this.chronology = ISOChronology.getInstance((DateTimeZone)granularity.getTimeZone());
            this.step = TimestampShiftExprMacro.getStep(args, ExprUtils.nilBindings());
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            return ExprEval.of((long)this.chronology.add((ReadablePeriod)this.period, this.arg.eval(bindings).asLong(), this.step));
        }

        public void visit(Expr.Visitor visitor) {
            this.arg.visit(visitor);
            visitor.visit((Expr)this);
        }
    }
}

