/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.expression;

import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.granularity.PeriodGranularity;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.expression.ExprUtils;
import java.util.List;
import javax.annotation.Nonnull;

public class TimestampFloorExprMacro
implements ExprMacroTable.ExprMacro {
    public String name() {
        return "timestamp_floor";
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 4) {
            throw new IAE("Function[%s] must have 2 to 4 arguments", new Object[]{this.name()});
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampFloorExpr(args);
        }
        return new TimestampFloorDynamicExpr(args);
    }

    private static PeriodGranularity computeGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    public static class TimestampFloorDynamicExpr
    implements Expr {
        private final List<Expr> args;

        public TimestampFloorDynamicExpr(List<Expr> args) {
            this.args = args;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampFloorExprMacro.computeGranularity(this.args, bindings);
            return ExprEval.of((long)granularity.bucketStart(DateTimes.utc((long)this.args.get(0).eval(bindings).asLong())).getMillis());
        }

        public void visit(Expr.Visitor visitor) {
            for (Expr arg : this.args) {
                arg.visit(visitor);
            }
            visitor.visit((Expr)this);
        }
    }

    public static class TimestampFloorExpr
    implements Expr {
        private final Expr arg;
        private final PeriodGranularity granularity;

        public TimestampFloorExpr(List<Expr> args) {
            this.arg = args.get(0);
            this.granularity = TimestampFloorExprMacro.computeGranularity(args, ExprUtils.nilBindings());
        }

        public Expr getArg() {
            return this.arg;
        }

        public PeriodGranularity getGranularity() {
            return this.granularity;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            return ExprEval.of((long)this.granularity.bucketStart(DateTimes.utc((long)this.arg.eval(bindings).asLong())).getMillis());
        }

        public void visit(Expr.Visitor visitor) {
            this.arg.visit(visitor);
            visitor.visit((Expr)this);
        }
    }
}

