/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.expression;

import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.granularity.PeriodGranularity;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.expression.ExprUtils;
import java.util.List;
import javax.annotation.Nonnull;

public class TimestampCeilExprMacro
implements ExprMacroTable.ExprMacro {
    public String name() {
        return "timestamp_ceil";
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 4) {
            throw new IAE("Function[%s] must have 2 to 4 arguments", new Object[]{this.name()});
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampCeilExpr(args);
        }
        return new TimestampCeilDynamicExpr(args);
    }

    private static PeriodGranularity getGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    private static class TimestampCeilDynamicExpr
    implements Expr {
        private final List<Expr> args;

        public TimestampCeilDynamicExpr(List<Expr> args) {
            this.args = args;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampCeilExprMacro.getGranularity(this.args, bindings);
            return ExprEval.of((long)granularity.bucketEnd(DateTimes.utc((long)this.args.get(0).eval(bindings).asLong())).getMillis());
        }

        public void visit(Expr.Visitor visitor) {
            for (Expr arg : this.args) {
                arg.visit(visitor);
            }
            visitor.visit((Expr)this);
        }
    }

    private static class TimestampCeilExpr
    implements Expr {
        private final Expr arg;
        private final Granularity granularity;

        public TimestampCeilExpr(List<Expr> args) {
            this.arg = args.get(0);
            this.granularity = TimestampCeilExprMacro.getGranularity(args, ExprUtils.nilBindings());
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            return ExprEval.of((long)this.granularity.bucketEnd(DateTimes.utc((long)this.arg.eval(bindings).asLong())).getMillis());
        }

        public void visit(Expr.Visitor visitor) {
            this.arg.visit(visitor);
            visitor.visit((Expr)this);
        }
    }
}

