/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.expression;

import io.druid.java.util.common.IAE;
import io.druid.java.util.common.granularity.PeriodGranularity;
import io.druid.math.expr.Expr;
import javax.annotation.Nullable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;

public class ExprUtils {
    private static final Expr.ObjectBinding NIL_BINDINGS = name -> null;

    public static Expr.ObjectBinding nilBindings() {
        return NIL_BINDINGS;
    }

    public static DateTimeZone toTimeZone(Expr timeZoneArg) {
        if (!timeZoneArg.isLiteral()) {
            throw new IAE("Time zone must be a literal", new Object[0]);
        }
        Object literalValue = timeZoneArg.getLiteralValue();
        return literalValue == null ? DateTimeZone.UTC : DateTimeZone.forID((String)((String)literalValue));
    }

    public static PeriodGranularity toPeriodGranularity(Expr periodArg, @Nullable Expr originArg, @Nullable Expr timeZoneArg, Expr.ObjectBinding bindings) {
        DateTime origin;
        DateTimeZone timeZone;
        Period period = new Period((Object)periodArg.eval(bindings).asString());
        if (timeZoneArg == null) {
            timeZone = null;
        } else {
            String value = timeZoneArg.eval(bindings).asString();
            DateTimeZone dateTimeZone = timeZone = value != null ? DateTimeZone.forID((String)value) : null;
        }
        if (originArg == null) {
            origin = null;
        } else {
            ISOChronology chronology = timeZone == null ? ISOChronology.getInstanceUTC() : ISOChronology.getInstance(timeZone);
            Object value = originArg.eval(bindings).value();
            origin = value != null ? new DateTime(value, (Chronology)chronology) : null;
        }
        return new PeriodGranularity(period, origin, timeZone);
    }
}

