/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import io.druid.java.util.common.StringUtils;
import io.druid.query.dimension.BaseFilteredDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ForwardingFilteredDimensionSelector;
import io.druid.query.dimension.PredicateFilteredDimensionSelector;
import io.druid.segment.DimensionSelector;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RegexFilteredDimensionSpec
extends BaseFilteredDimensionSpec {
    private static final byte CACHE_TYPE_ID = 2;
    private final String pattern;
    private final Pattern compiledRegex;

    public RegexFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="pattern") String pattern) {
        super(delegate);
        this.pattern = (String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern must not be null");
        this.compiledRegex = Pattern.compile(pattern);
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        if (selector == null) {
            return null;
        }
        int selectorCardinality = selector.getValueCardinality();
        if (selectorCardinality < 0 || !selector.nameLookupPossibleInAdvance()) {
            return new PredicateFilteredDimensionSelector(selector, new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return RegexFilteredDimensionSpec.this.compiledRegex.matcher(Strings.nullToEmpty((String)input)).matches();
                }
            });
        }
        int count = 0;
        Int2IntOpenHashMap forwardMapping = new Int2IntOpenHashMap();
        forwardMapping.defaultReturnValue(-1);
        for (int i = 0; i < selectorCardinality; ++i) {
            if (!this.compiledRegex.matcher(Strings.nullToEmpty((String)selector.lookupName(i))).matches()) continue;
            forwardMapping.put(i, count++);
        }
        int[] reverseMapping = new int[forwardMapping.size()];
        for (Int2IntMap.Entry e : forwardMapping.int2IntEntrySet()) {
            reverseMapping[e.getIntValue()] = e.getIntKey();
        }
        return new ForwardingFilteredDimensionSelector(selector, forwardMapping, reverseMapping);
    }

    public byte[] getCacheKey() {
        byte[] delegateCacheKey = this.delegate.getCacheKey();
        byte[] regexBytes = StringUtils.toUtf8((String)this.pattern);
        return ByteBuffer.allocate(2 + delegateCacheKey.length + regexBytes.length).put((byte)2).put(delegateCacheKey).put((byte)-1).put(regexBytes).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexFilteredDimensionSpec that = (RegexFilteredDimensionSpec)o;
        if (!this.delegate.equals(that.delegate)) {
            return false;
        }
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        int result = this.delegate.hashCode();
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    public String toString() {
        return "RegexFilteredDimensionSpec{pattern='" + this.pattern + '\'' + '}';
    }
}

