/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.druid.java.util.common.IAE;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.DimensionSelectorUtils;
import io.druid.segment.IdLookup;
import io.druid.segment.data.ArrayBasedIndexedInts;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.BooleanValueMatcher;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.BitSet;
import javax.annotation.Nullable;

final class ForwardingFilteredDimensionSelector
implements DimensionSelector,
IdLookup {
    private final DimensionSelector selector;
    private final IdLookup baseIdLookup;
    private final Int2IntOpenHashMap forwardMapping;
    private final int[] reverseMapping;

    ForwardingFilteredDimensionSelector(DimensionSelector selector, Int2IntOpenHashMap forwardMapping, int[] reverseMapping) {
        this.selector = (DimensionSelector)Preconditions.checkNotNull((Object)selector);
        if (!selector.nameLookupPossibleInAdvance()) {
            throw new IAE("selector.nameLookupPossibleInAdvance() should return true", new Object[0]);
        }
        this.baseIdLookup = selector.idLookup();
        this.forwardMapping = (Int2IntOpenHashMap)Preconditions.checkNotNull((Object)forwardMapping);
        if (forwardMapping.defaultReturnValue() != -1) {
            throw new IAE("forwardMapping.defaultReturnValue() should be -1", new Object[0]);
        }
        this.reverseMapping = (int[])Preconditions.checkNotNull((Object)reverseMapping);
    }

    @Override
    public IndexedInts getRow() {
        IndexedInts baseRow = this.selector.getRow();
        int baseRowSize = baseRow.size();
        int[] result = new int[baseRowSize];
        int resultSize = 0;
        for (int i = 0; i < baseRowSize; ++i) {
            int forwardedValue = this.forwardMapping.get(baseRow.get(i));
            if (forwardedValue < 0) continue;
            result[resultSize++] = forwardedValue;
        }
        return ArrayBasedIndexedInts.of(result, resultSize);
    }

    @Override
    public ValueMatcher makeValueMatcher(final String value) {
        IdLookup idLookup = this.idLookup();
        if (idLookup != null) {
            final int valueId = idLookup.lookupId(value);
            if (valueId >= 0 || value == null) {
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        IndexedInts baseRow = ForwardingFilteredDimensionSelector.this.selector.getRow();
                        int baseRowSize = baseRow.size();
                        boolean nullRow = true;
                        for (int i = 0; i < baseRowSize; ++i) {
                            int forwardedValue = ForwardingFilteredDimensionSelector.this.forwardMapping.get(baseRow.get(i));
                            if (forwardedValue < 0) continue;
                            if (forwardedValue == valueId) {
                                return true;
                            }
                            nullRow = false;
                        }
                        return nullRow && value == null;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", ForwardingFilteredDimensionSelector.this.selector);
                    }
                };
            }
            return BooleanValueMatcher.of(false);
        }
        return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        final BitSet valueIds = DimensionSelectorUtils.makePredicateMatchingSet(this, predicate);
        final boolean matchNull = predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts baseRow = ForwardingFilteredDimensionSelector.this.selector.getRow();
                int baseRowSize = baseRow.size();
                boolean nullRow = true;
                for (int i = 0; i < baseRowSize; ++i) {
                    int forwardedValue = ForwardingFilteredDimensionSelector.this.forwardMapping.get(baseRow.get(i));
                    if (forwardedValue < 0) continue;
                    if (valueIds.get(forwardedValue)) {
                        return true;
                    }
                    nullRow = false;
                }
                return nullRow && matchNull;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", ForwardingFilteredDimensionSelector.this.selector);
            }
        };
    }

    @Override
    public int getValueCardinality() {
        return this.forwardMapping.size();
    }

    @Override
    public String lookupName(int id) {
        return this.selector.lookupName(this.reverseMapping[id]);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this.baseIdLookup != null ? this : null;
    }

    @Override
    public int lookupId(String name) {
        return this.forwardMapping.get(this.baseIdLookup.lookupId(name));
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.defaultGetObject();
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

