/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.java.util.common.StringUtils;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.segment.DimensionSelector;
import io.druid.segment.column.ValueType;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class DefaultDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 0;
    private final String dimension;
    private final String outputName;
    private final ValueType outputType;

    public static DefaultDimensionSpec of(String dimensionName) {
        return new DefaultDimensionSpec(dimensionName, dimensionName);
    }

    public static List<DimensionSpec> toSpec(String ... dimensionNames) {
        return DefaultDimensionSpec.toSpec(Arrays.asList(dimensionNames));
    }

    public static List<DimensionSpec> toSpec(Iterable<String> dimensionNames) {
        return Lists.newArrayList((Iterable)Iterables.transform(dimensionNames, (Function)new Function<String, DimensionSpec>(){

            public DimensionSpec apply(String input) {
                return new DefaultDimensionSpec(input, input);
            }
        }));
    }

    @JsonCreator
    public DefaultDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="outputType") ValueType outputType) {
        this.dimension = dimension;
        this.outputType = outputType == null ? ValueType.STRING : outputType;
        this.outputName = outputName == null ? dimension : outputName;
    }

    public DefaultDimensionSpec(String dimension, String outputName) {
        this(dimension, outputName, ValueType.STRING);
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    @JsonProperty
    public ValueType getOutputType() {
        return this.outputType;
    }

    @Override
    public ExtractionFn getExtractionFn() {
        return null;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        return selector;
    }

    @Override
    public boolean mustDecorate() {
        return false;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        return ByteBuffer.allocate(1 + dimensionBytes.length).put((byte)0).put(dimensionBytes).array();
    }

    @Override
    public boolean preservesOrdering() {
        return true;
    }

    public String toString() {
        return "DefaultDimensionSpec{dimension='" + this.dimension + '\'' + ", outputName='" + this.outputName + '\'' + ", outputType='" + (Object)((Object)this.outputType) + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultDimensionSpec)) {
            return false;
        }
        DefaultDimensionSpec that = (DefaultDimensionSpec)o;
        if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) {
            return false;
        }
        if (this.outputName != null ? !this.outputName.equals(that.outputName) : that.outputName != null) {
            return false;
        }
        return !(this.outputType != null ? !this.outputType.equals((Object)that.outputType) : that.outputType != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.outputName != null ? this.outputName.hashCode() : 0);
        result = 31 * result + (this.outputType != null ? this.outputType.hashCode() : 0);
        return result;
    }
}

