/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.datasourcemetadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.BySegmentSkippingQueryRunner;
import io.druid.query.CacheStrategy;
import io.druid.query.GenericQueryMetricsFactory;
import io.druid.query.Query;
import io.druid.query.QueryMetrics;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import io.druid.timeline.LogicalSegment;
import java.util.List;
import java.util.Map;
import org.joda.time.ReadableInterval;

public class DataSourceQueryQueryToolChest
extends QueryToolChest<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> {
    private static final TypeReference<Result<DataSourceMetadataResultValue>> TYPE_REFERENCE = new TypeReference<Result<DataSourceMetadataResultValue>>(){};
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @Inject
    public DataSourceQueryQueryToolChest(GenericQueryMetricsFactory queryMetricsFactory) {
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(DataSourceMetadataQuery query, List<T> segments) {
        if (segments.size() <= 1) {
            return segments;
        }
        final LogicalSegment max = (LogicalSegment)segments.get(segments.size() - 1);
        return Lists.newArrayList((Iterable)Iterables.filter(segments, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return max != null && input.getInterval().overlaps((ReadableInterval)max.getInterval());
            }
        }));
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> mergeResults(QueryRunner<Result<DataSourceMetadataResultValue>> runner) {
        return new BySegmentSkippingQueryRunner<Result<DataSourceMetadataResultValue>>(runner){

            @Override
            protected Sequence<Result<DataSourceMetadataResultValue>> doRun(QueryRunner<Result<DataSourceMetadataResultValue>> baseRunner, QueryPlus<Result<DataSourceMetadataResultValue>> input, Map<String, Object> context) {
                DataSourceMetadataQuery query = (DataSourceMetadataQuery)input.getQuery();
                return Sequences.simple(query.mergeResults(Sequences.toList(baseRunner.run(input, context), (List)Lists.newArrayList())));
            }
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(DataSourceMetadataQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<Result<DataSourceMetadataResultValue>, Result<DataSourceMetadataResultValue>> makePreComputeManipulatorFn(DataSourceMetadataQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<DataSourceMetadataResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy getCacheStrategy(DataSourceMetadataQuery query) {
        return null;
    }
}

