/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.datasourcemetadata;

import com.google.inject.Inject;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.BaseSequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import io.druid.query.datasourcemetadata.DataSourceQueryQueryToolChest;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class DataSourceMetadataQueryRunnerFactory
implements QueryRunnerFactory<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> {
    private final DataSourceQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public DataSourceMetadataQueryRunnerFactory(DataSourceQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> createRunner(Segment segment) {
        return new DataSourceMetadataQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<DataSourceMetadataResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<DataSourceMetadataResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> getToolchest() {
        return this.toolChest;
    }

    private static class DataSourceMetadataQueryRunner
    implements QueryRunner<Result<DataSourceMetadataResultValue>> {
        private final StorageAdapter adapter;

        public DataSourceMetadataQueryRunner(Segment segment) {
            this.adapter = segment.asStorageAdapter();
        }

        @Override
        public Sequence<Result<DataSourceMetadataResultValue>> run(QueryPlus<Result<DataSourceMetadataResultValue>> input, Map<String, Object> responseContext) {
            Query<Result<DataSourceMetadataResultValue>> query = input.getQuery();
            if (!(query instanceof DataSourceMetadataQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{query.getClass().getCanonicalName(), DataSourceMetadataQuery.class});
            }
            final DataSourceMetadataQuery legacyQuery = (DataSourceMetadataQuery)query;
            return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Result<DataSourceMetadataResultValue>, Iterator<Result<DataSourceMetadataResultValue>>>(){

                public Iterator<Result<DataSourceMetadataResultValue>> make() {
                    if (adapter == null) {
                        throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                    }
                    return legacyQuery.buildResult(adapter.getInterval().getStart(), adapter.getMaxIngestedEventTime()).iterator();
                }

                public void cleanup(Iterator<Result<DataSourceMetadataResultValue>> toClean) {
                }
            });
        }
    }
}

