/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.datasourcemetadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.query.BaseQuery;
import io.druid.query.DataSource;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.Result;
import io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import io.druid.query.filter.DimFilter;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DataSourceMetadataQuery
extends BaseQuery<Result<DataSourceMetadataResultValue>> {
    private static final QuerySegmentSpec DEFAULT_SEGMENT_SPEC = new MultipleIntervalSegmentSpec((List<Interval>)Intervals.ONLY_ETERNITY);

    @JsonCreator
    public DataSourceMetadataQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec == null ? DEFAULT_SEGMENT_SPEC : querySegmentSpec, false, context);
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    public DimFilter getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return "dataSourceMetadata";
    }

    public DataSourceMetadataQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        Map<String, Object> newContext = DataSourceMetadataQuery.computeOverriddenContext(this.getContext(), contextOverrides);
        return Druids.DataSourceMetadataQueryBuilder.copy(this).context(newContext).build();
    }

    public DataSourceMetadataQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return Druids.DataSourceMetadataQueryBuilder.copy(this).intervals(spec).build();
    }

    @Override
    public Query<Result<DataSourceMetadataResultValue>> withDataSource(DataSource dataSource) {
        return Druids.DataSourceMetadataQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    public Iterable<Result<DataSourceMetadataResultValue>> buildResult(DateTime timestamp, DateTime maxIngestedEventTime) {
        return Collections.singletonList(new Result<DataSourceMetadataResultValue>(timestamp, new DataSourceMetadataResultValue(maxIngestedEventTime)));
    }

    public Iterable<Result<DataSourceMetadataResultValue>> mergeResults(List<Result<DataSourceMetadataResultValue>> results) {
        if (results == null || results.isEmpty()) {
            return Lists.newArrayList();
        }
        DateTime max = DateTimes.MIN;
        for (Result<DataSourceMetadataResultValue> result : results) {
            DateTime currMaxIngestedEventTime = result.getValue().getMaxIngestedEventTime();
            if (currMaxIngestedEventTime == null || !currMaxIngestedEventTime.isAfter((ReadableInstant)max)) continue;
            max = currMaxIngestedEventTime;
        }
        return this.buildResult(max, max);
    }

    public String toString() {
        return "DataSourceMetadataQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", duration=" + this.getDuration() + '}';
    }
}

