/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.druid.java.util.common.guava.Comparators;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class FinalizingFieldAccessPostAggregator
implements PostAggregator {
    private final String name;
    private final String fieldName;

    @JsonCreator
    public FinalizingFieldAccessPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        throw new UnsupportedOperationException("No decorated");
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public FinalizingFieldAccessPostAggregator decorate(final Map<String, AggregatorFactory> aggregators) {
        return new FinalizingFieldAccessPostAggregator(this.name, this.fieldName){

            @Override
            public Comparator getComparator() {
                if (aggregators != null && aggregators.containsKey(FinalizingFieldAccessPostAggregator.this.fieldName)) {
                    return ((AggregatorFactory)aggregators.get(FinalizingFieldAccessPostAggregator.this.fieldName)).getComparator();
                }
                return Comparators.naturalNullsFirst();
            }

            @Override
            public Object compute(Map<String, Object> combinedAggregators) {
                if (aggregators != null && aggregators.containsKey(FinalizingFieldAccessPostAggregator.this.fieldName)) {
                    return ((AggregatorFactory)aggregators.get(FinalizingFieldAccessPostAggregator.this.fieldName)).finalizeComputation(combinedAggregators.get(FinalizingFieldAccessPostAggregator.this.fieldName));
                }
                return combinedAggregators.get(FinalizingFieldAccessPostAggregator.this.fieldName);
            }
        };
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(20).appendString(this.fieldName).build();
    }

    public String toString() {
        return "FinalizingFieldAccessPostAggregator{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizingFieldAccessPostAggregator that = (FinalizingFieldAccessPostAggregator)o;
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }

    @VisibleForTesting
    static FinalizingFieldAccessPostAggregator buildDecorated(String name, String fieldName, Map<String, AggregatorFactory> aggregators) {
        FinalizingFieldAccessPostAggregator ret = new FinalizingFieldAccessPostAggregator(name, fieldName);
        return ret.decorate((Map)aggregators);
    }
}

