/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.druid.query.Queries;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DoubleLeastPostAggregator
implements PostAggregator {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return ((Double)o).compareTo((Double)o1);
        }
    };
    private final String name;
    private final List<PostAggregator> fields;

    @JsonCreator
    public DoubleLeastPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fields") List<PostAggregator> fields) {
        Preconditions.checkArgument((fields != null && fields.size() > 0 ? 1 : 0) != 0, (Object)"Illegal number of fields[%s], must be > 0");
        this.name = name;
        this.fields = fields;
    }

    @Override
    public Set<String> getDependentFields() {
        HashSet dependentFields = Sets.newHashSet();
        for (PostAggregator field : this.fields) {
            dependentFields.addAll(field.getDependentFields());
        }
        return dependentFields;
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Iterator<PostAggregator> fieldsIter = this.fields.iterator();
        double retVal = Double.POSITIVE_INFINITY;
        if (fieldsIter.hasNext()) {
            retVal = ((Number)fieldsIter.next().compute(values)).doubleValue();
            while (fieldsIter.hasNext()) {
                double other = ((Number)fieldsIter.next().compute(values)).doubleValue();
                if (!(other < retVal)) continue;
                retVal = other;
            }
        }
        return retVal;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public DoubleLeastPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return new DoubleLeastPostAggregator(this.name, Queries.decoratePostAggregators(this.fields, aggregators));
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    public String toString() {
        return "DoubleLeastPostAggregator{name='" + this.name + '\'' + ", fields=" + this.fields + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleLeastPostAggregator that = (DoubleLeastPostAggregator)o;
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.fields.hashCode();
        return result;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(3).appendCacheablesIgnoringOrder(this.fields).build();
    }
}

