/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.last;

import io.druid.collections.SerializablePair;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseDoubleColumnValueSelector;
import io.druid.segment.BaseLongColumnValueSelector;
import java.nio.ByteBuffer;

public class DoubleLastBufferAggregator
implements BufferAggregator {
    private final BaseLongColumnValueSelector timeSelector;
    private final BaseDoubleColumnValueSelector valueSelector;

    public DoubleLastBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseDoubleColumnValueSelector valueSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MIN_VALUE);
        buf.putDouble(position + 8, 0.0);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        long lastTime;
        long time = this.timeSelector.getLong();
        if (time >= (lastTime = buf.getLong(position))) {
            buf.putLong(position, time);
            buf.putDouble(position + 8, this.valueSelector.getDouble());
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return new SerializablePair((Object)buf.getLong(position), (Object)buf.getDouble(position + 8));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)buf.getDouble(position + 8);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getDouble(position + 8);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getDouble(position + 8);
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("timeSelector", this.timeSelector);
        inspector.visit("valueSelector", this.valueSelector);
    }
}

