/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import io.druid.data.input.InputRow;
import io.druid.hll.HyperLogLogCollector;
import io.druid.hll.HyperLogLogHash;
import io.druid.java.util.common.ISE;
import io.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import io.druid.segment.serde.ComplexMetricExtractor;
import java.nio.ByteBuffer;
import org.apache.commons.codec.binary.Base64;

public class PreComputedHyperUniquesSerde
extends HyperUniquesSerde {
    public PreComputedHyperUniquesSerde(HyperLogLogHash hyperLogLogHash) {
        super(hyperLogLogHash);
    }

    @Override
    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<HyperLogLogCollector> extractedClass() {
                return HyperLogLogCollector.class;
            }

            public HyperLogLogCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue == null) {
                    return HyperLogLogCollector.makeLatestCollector();
                }
                if (rawValue instanceof HyperLogLogCollector) {
                    return (HyperLogLogCollector)rawValue;
                }
                if (rawValue instanceof byte[]) {
                    return HyperLogLogCollector.makeLatestCollector().fold(ByteBuffer.wrap((byte[])rawValue));
                }
                if (rawValue instanceof String) {
                    return HyperLogLogCollector.makeLatestCollector().fold(ByteBuffer.wrap(Base64.decodeBase64((String)((String)rawValue))));
                }
                throw new ISE("Object is not of a type[%s] that can be deserialized to HyperLogLog.", new Object[]{rawValue.getClass()});
            }
        };
    }
}

