/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.cache.CacheKeyBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class HyperUniqueFinalizingPostAggregator
implements PostAggregator {
    private static final Comparator<Double> DOUBLE_COMPARATOR = Ordering.from((Comparator)new Comparator<Double>(){

        @Override
        public int compare(Double lhs, Double rhs) {
            return Double.compare(lhs, rhs);
        }
    }).nullsFirst();
    private final String name;
    private final String fieldName;
    private final AggregatorFactory aggregatorFactory;

    @JsonCreator
    public HyperUniqueFinalizingPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this(name, fieldName, null);
    }

    private HyperUniqueFinalizingPostAggregator(String name, String fieldName, AggregatorFactory aggregatorFactory) {
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName is null");
        this.name = name == null ? fieldName : name;
        this.aggregatorFactory = aggregatorFactory;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Comparator<Double> getComparator() {
        return DOUBLE_COMPARATOR;
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        Object collector = combinedAggregators.get(this.fieldName);
        if (this.aggregatorFactory == null) {
            return HyperUniquesAggregatorFactory.estimateCardinality(collector, false);
        }
        return this.aggregatorFactory.finalizeComputation(collector);
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    public HyperUniqueFinalizingPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        AggregatorFactory theAggregatorFactory = aggregators != null ? aggregators.get(this.fieldName) : null;
        return new HyperUniqueFinalizingPostAggregator(this.name, this.fieldName, theAggregatorFactory);
    }

    @JsonProperty(value="fieldName")
    public String getFieldName() {
        return this.fieldName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HyperUniqueFinalizingPostAggregator that = (HyperUniqueFinalizingPostAggregator)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.fieldName != null ? this.fieldName.equals(that.fieldName) : that.fieldName == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HyperUniqueFinalizingPostAggregator{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(9).appendString(this.fieldName).build();
    }
}

