/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality.types;

import com.google.common.hash.Hasher;
import io.druid.hll.HyperLogLogCollector;
import io.druid.query.aggregation.cardinality.CardinalityAggregator;
import io.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import java.util.Arrays;

public class StringCardinalityAggregatorColumnSelectorStrategy
implements CardinalityAggregatorColumnSelectorStrategy<DimensionSelector> {
    public static final String CARDINALITY_AGG_NULL_STRING = "\u0000";
    public static final char CARDINALITY_AGG_SEPARATOR = '\u0001';

    @Override
    public void hashRow(DimensionSelector dimSelector, Hasher hasher) {
        IndexedInts row = dimSelector.getRow();
        int size = row.size();
        if (size == 1) {
            String value = dimSelector.lookupName(row.get(0));
            hasher.putUnencodedChars((CharSequence)this.nullToSpecial(value));
        } else if (size != 0) {
            int i;
            Object[] values = new String[size];
            for (i = 0; i < size; ++i) {
                String value = dimSelector.lookupName(row.get(i));
                values[i] = this.nullToSpecial(value);
            }
            Arrays.sort(values);
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    hasher.putChar('\u0001');
                }
                hasher.putUnencodedChars((CharSequence)values[i]);
            }
        }
    }

    @Override
    public void hashValues(DimensionSelector dimSelector, HyperLogLogCollector collector) {
        IndexedInts row = dimSelector.getRow();
        for (int i = 0; i < row.size(); ++i) {
            int index = row.get(i);
            String value = dimSelector.lookupName(index);
            collector.add(CardinalityAggregator.hashFn.hashUnencodedChars((CharSequence)this.nullToSpecial(value)).asBytes());
        }
    }

    private String nullToSpecial(String value) {
        return value == null ? CARDINALITY_AGG_NULL_STRING : value;
    }
}

