/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality.types;

import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import io.druid.query.aggregation.cardinality.types.DoubleCardinalityAggregatorColumnSelectorStrategy;
import io.druid.query.aggregation.cardinality.types.FloatCardinalityAggregatorColumnSelectorStrategy;
import io.druid.query.aggregation.cardinality.types.LongCardinalityAggregatorColumnSelectorStrategy;
import io.druid.query.aggregation.cardinality.types.StringCardinalityAggregatorColumnSelectorStrategy;
import io.druid.query.dimension.ColumnSelectorStrategyFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ValueType;

public class CardinalityAggregatorColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<CardinalityAggregatorColumnSelectorStrategy> {
    @Override
    public CardinalityAggregatorColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        ValueType type = capabilities.getType();
        switch (type) {
            case STRING: {
                return new StringCardinalityAggregatorColumnSelectorStrategy();
            }
            case LONG: {
                return new LongCardinalityAggregatorColumnSelectorStrategy();
            }
            case FLOAT: {
                return new FloatCardinalityAggregatorColumnSelectorStrategy();
            }
            case DOUBLE: {
                return new DoubleCardinalityAggregatorColumnSelectorStrategy();
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
    }
}

