/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality;

import io.druid.hll.HyperLogLogCollector;
import io.druid.query.ColumnSelectorPlus;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.cardinality.CardinalityAggregator;
import io.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import java.nio.ByteBuffer;

public class CardinalityBufferAggregator
implements BufferAggregator {
    private final ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses;
    private final boolean byRow;
    private static final byte[] EMPTY_BYTES = HyperLogLogCollector.makeEmptyVersionedByteArray();

    CardinalityBufferAggregator(ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses, boolean byRow) {
        this.selectorPluses = selectorPluses;
        this.byRow = byRow;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.put(EMPTY_BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
        buf.position(position);
        try {
            HyperLogLogCollector collector = HyperLogLogCollector.makeCollector((ByteBuffer)buf);
            if (this.byRow) {
                CardinalityAggregator.hashRow(this.selectorPluses, collector);
            } else {
                CardinalityAggregator.hashValues(this.selectorPluses, collector);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        ByteBuffer dataCopyBuffer = ByteBuffer.allocate(HyperLogLogCollector.getLatestNumBytesForDenseStorage());
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.get(dataCopyBuffer.array());
        return HyperLogLogCollector.makeCollector((ByteBuffer)dataCopyBuffer);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("CardinalityBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("CardinalityBufferAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("CardinalityBufferAggregators does not support getDouble()");
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selectorPluses", (T[])this.selectorPluses);
    }
}

