/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.druid.hll.HyperLogLogCollector;
import io.druid.query.ColumnSelectorPlus;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import java.util.List;

public class CardinalityAggregator
implements Aggregator {
    private final String name;
    private final ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses;
    private final boolean byRow;
    public static final HashFunction hashFn = Hashing.murmur3_128();
    private HyperLogLogCollector collector;

    static void hashRow(ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses, HyperLogLogCollector collector) {
        Hasher hasher = hashFn.newHasher();
        for (int k = 0; k < selectorPluses.length; ++k) {
            if (k != 0) {
                hasher.putByte((byte)0);
            }
            ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy> selectorPlus = selectorPluses[k];
            selectorPlus.getColumnSelectorStrategy().hashRow(selectorPlus.getSelector(), hasher);
        }
        collector.add(hasher.hash().asBytes());
    }

    static void hashValues(ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses, HyperLogLogCollector collector) {
        for (ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy> selectorPlus : selectorPluses) {
            selectorPlus.getColumnSelectorStrategy().hashValues(selectorPlus.getSelector(), collector);
        }
    }

    @VisibleForTesting
    CardinalityAggregator(String name, List<ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>> selectorPlusList, boolean byRow) {
        this(name, selectorPlusList.toArray(new ColumnSelectorPlus[0]), byRow);
    }

    CardinalityAggregator(String name, ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses, boolean byRow) {
        this.name = name;
        this.selectorPluses = selectorPluses;
        this.collector = HyperLogLogCollector.makeLatestCollector();
        this.byRow = byRow;
    }

    @Override
    public void aggregate() {
        if (this.byRow) {
            CardinalityAggregator.hashRow(this.selectorPluses, this.collector);
        } else {
            CardinalityAggregator.hashValues(this.selectorPluses, this.collector);
        }
    }

    @Override
    public Object get() {
        return HyperLogLogCollector.makeCollectorSharingStorage((HyperLogLogCollector)this.collector);
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("CardinalityAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("CardinalityAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("CardinalityAggregator does not support getDouble()");
    }

    public Aggregator clone() {
        return new CardinalityAggregator(this.name, this.selectorPluses, this.byRow);
    }

    @Override
    public void close() {
    }
}

