/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.primitives.Longs;
import io.druid.query.aggregation.Aggregator;
import io.druid.segment.BaseLongColumnValueSelector;
import java.util.Comparator;

public class LongSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Longs.compare((long)((Number)o).longValue(), (long)((Number)o1).longValue());
        }
    };
    private final BaseLongColumnValueSelector selector;
    private long sum;

    static long combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).longValue() + ((Number)rhs).longValue();
    }

    public LongSumAggregator(BaseLongColumnValueSelector selector) {
        this.selector = selector;
        this.sum = 0L;
    }

    @Override
    public void aggregate() {
        this.sum += this.selector.getLong();
    }

    @Override
    public Object get() {
        return this.sum;
    }

    @Override
    public float getFloat() {
        return this.sum;
    }

    @Override
    public long getLong() {
        return this.sum;
    }

    @Override
    public double getDouble() {
        return this.sum;
    }

    public Aggregator clone() {
        return new LongSumAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

