/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.java.util.common.StringUtils;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprMacroTable;
import io.druid.math.expr.Parser;
import io.druid.query.aggregation.AggregateCombiner;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import io.druid.query.aggregation.AggregatorUtil;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.LongAggregateCombiner;
import io.druid.query.aggregation.LongMinAggregator;
import io.druid.query.aggregation.LongMinBufferAggregator;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class LongMinAggregatorFactory
extends AggregatorFactory {
    private final String name;
    private final String fieldName;
    private final String expression;
    private final ExprMacroTable macroTable;

    @JsonCreator
    public LongMinAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkArgument((boolean)(fieldName == null ^ expression == null), (Object)"Must have a valid, non-null fieldName or expression");
        this.name = name;
        this.fieldName = fieldName;
        this.expression = expression;
        this.macroTable = macroTable;
    }

    public LongMinAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new LongMinAggregator(this.getLongColumnSelector(metricFactory));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new LongMinBufferAggregator(this.getLongColumnSelector(metricFactory));
    }

    private BaseLongColumnValueSelector getLongColumnSelector(ColumnSelectorFactory metricFactory) {
        return AggregatorUtil.makeColumnValueSelectorWithLongDefault(metricFactory, this.macroTable, this.fieldName, this.expression, Long.MAX_VALUE);
    }

    @Override
    public Comparator getComparator() {
        return LongMinAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return LongMinAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new LongAggregateCombiner(){
            private long min;

            @Override
            public void reset(ColumnValueSelector selector) {
                this.min = selector.getLong();
            }

            @Override
            public void fold(ColumnValueSelector selector) {
                this.min = Math.min(this.min, selector.getLong());
            }

            @Override
            public long getLong() {
                return this.min;
            }
        };
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new LongMinAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new LongMinAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldName != null ? Collections.singletonList(this.fieldName) : Parser.findRequiredBindings((Expr)Parser.parse((String)this.expression, (ExprMacroTable)this.macroTable));
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty((String)this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty((String)this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)11).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    @Override
    public String getTypeName() {
        return "long";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    public String toString() {
        return "LongMinAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongMinAggregatorFactory that = (LongMinAggregatorFactory)o;
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

