/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.LongSumAggregator;
import io.druid.segment.BaseLongColumnValueSelector;
import java.util.Comparator;

public class LongMinAggregator
implements Aggregator {
    static final Comparator COMPARATOR = LongSumAggregator.COMPARATOR;
    private final BaseLongColumnValueSelector selector;
    private long min;

    static long combineValues(Object lhs, Object rhs) {
        return Math.min(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    public LongMinAggregator(BaseLongColumnValueSelector selector) {
        this.selector = selector;
        this.min = Long.MAX_VALUE;
    }

    @Override
    public void aggregate() {
        this.min = Math.min(this.min, this.selector.getLong());
    }

    @Override
    public Object get() {
        return this.min;
    }

    @Override
    public float getFloat() {
        return this.min;
    }

    @Override
    public long getLong() {
        return this.min;
    }

    @Override
    public double getDouble() {
        return this.min;
    }

    public Aggregator clone() {
        return new LongMinAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

