/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.LongSumAggregator;
import io.druid.segment.BaseLongColumnValueSelector;
import java.util.Comparator;

public class LongMaxAggregator
implements Aggregator {
    static final Comparator COMPARATOR = LongSumAggregator.COMPARATOR;
    private final BaseLongColumnValueSelector selector;
    private long max;

    static long combineValues(Object lhs, Object rhs) {
        return Math.max(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    public LongMaxAggregator(BaseLongColumnValueSelector selector) {
        this.selector = selector;
        this.max = Long.MIN_VALUE;
    }

    @Override
    public void aggregate() {
        this.max = Math.max(this.max, this.selector.getLong());
    }

    @Override
    public Object get() {
        return this.max;
    }

    @Override
    public float getFloat() {
        return this.max;
    }

    @Override
    public long getLong() {
        return this.max;
    }

    @Override
    public double getDouble() {
        return this.max;
    }

    public Aggregator clone() {
        return new LongMaxAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

