/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;

public class HistogramVisual {
    @JsonProperty
    public final double[] breaks;
    @JsonProperty
    public final double[] counts;
    @JsonProperty
    public final double[] quantiles;

    @JsonCreator
    public HistogramVisual(@JsonProperty double[] breaks, @JsonProperty double[] counts, @JsonProperty double[] quantiles) {
        Preconditions.checkArgument((breaks != null ? 1 : 0) != 0, (Object)"breaks must not be null");
        Preconditions.checkArgument((counts != null ? 1 : 0) != 0, (Object)"counts must not be null");
        Preconditions.checkArgument((breaks.length == counts.length + 1 ? 1 : 0) != 0, (Object)"breaks.length must be counts.length + 1");
        this.breaks = breaks;
        this.counts = counts;
        this.quantiles = quantiles;
    }

    public HistogramVisual(float[] breaks, float[] counts, float[] quantiles) {
        int i;
        Preconditions.checkArgument((breaks != null ? 1 : 0) != 0, (Object)"breaks must not be null");
        Preconditions.checkArgument((counts != null ? 1 : 0) != 0, (Object)"counts must not be null");
        Preconditions.checkArgument((breaks.length == counts.length + 1 ? 1 : 0) != 0, (Object)"breaks.length must be counts.length + 1");
        this.breaks = new double[breaks.length];
        this.counts = new double[counts.length];
        this.quantiles = new double[quantiles.length];
        for (i = 0; i < breaks.length; ++i) {
            this.breaks[i] = breaks[i];
        }
        for (i = 0; i < counts.length; ++i) {
            this.counts[i] = counts[i];
        }
        for (i = 0; i < quantiles.length; ++i) {
            this.quantiles[i] = quantiles[i];
        }
    }

    public String toString() {
        return "HistogramVisual{counts=" + Arrays.toString(this.counts) + ", breaks=" + Arrays.toString(this.breaks) + ", quantiles=" + Arrays.toString(this.quantiles) + '}';
    }
}

