/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Ordering;
import io.druid.query.aggregation.Aggregator;
import io.druid.segment.BaseFloatColumnValueSelector;
import java.util.Comparator;

public class FloatSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Ordering(){

        public int compare(Object o, Object o1) {
            return Float.compare(((Number)o).floatValue(), ((Number)o1).floatValue());
        }
    }.nullsFirst();
    private final BaseFloatColumnValueSelector selector;
    private float sum;

    static double combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).floatValue() + ((Number)rhs).floatValue();
    }

    public FloatSumAggregator(BaseFloatColumnValueSelector selector) {
        this.selector = selector;
        this.sum = 0.0f;
    }

    @Override
    public void aggregate() {
        this.sum += this.selector.getFloat();
    }

    @Override
    public Object get() {
        return Float.valueOf(this.sum);
    }

    @Override
    public float getFloat() {
        return this.sum;
    }

    @Override
    public long getLong() {
        return (long)this.sum;
    }

    @Override
    public double getDouble() {
        return this.sum;
    }

    public Aggregator clone() {
        return new FloatSumAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

