/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.java.util.common.StringUtils;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.aggregation.AggregateCombiner;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.DoubleMaxAggregateCombiner;
import io.druid.query.aggregation.FloatMaxAggregator;
import io.druid.query.aggregation.FloatMaxBufferAggregator;
import io.druid.query.aggregation.SimpleFloatAggregatorFactory;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class FloatMaxAggregatorFactory
extends SimpleFloatAggregatorFactory {
    @JsonCreator
    public FloatMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
    }

    public FloatMaxAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new FloatMaxAggregator(this.makeColumnValueSelectorWithFloatDefault(metricFactory, Float.NEGATIVE_INFINITY));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new FloatMaxBufferAggregator(this.makeColumnValueSelectorWithFloatDefault(metricFactory, Float.NEGATIVE_INFINITY));
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return FloatMaxAggregator.combineValues(this.finalizeComputation(lhs), this.finalizeComputation(rhs));
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleMaxAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatMaxAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new FloatMaxAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty((String)this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty((String)this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)13).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    public String toString() {
        return "FloatMaxAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

