/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.Aggregator;
import io.druid.segment.BaseFloatColumnValueSelector;

public class FloatMaxAggregator
implements Aggregator {
    private final BaseFloatColumnValueSelector selector;
    private float max;

    static double combineValues(Object lhs, Object rhs) {
        return Math.max(((Number)lhs).floatValue(), ((Number)rhs).floatValue());
    }

    public FloatMaxAggregator(BaseFloatColumnValueSelector selector) {
        this.selector = selector;
        this.max = Float.NEGATIVE_INFINITY;
    }

    @Override
    public void aggregate() {
        this.max = Math.max(this.max, this.selector.getFloat());
    }

    @Override
    public Object get() {
        return Float.valueOf(this.max);
    }

    @Override
    public float getFloat() {
        return this.max;
    }

    @Override
    public long getLong() {
        return (long)this.max;
    }

    @Override
    public double getDouble() {
        return this.max;
    }

    public Aggregator clone() {
        return new FloatMaxAggregator(this.selector);
    }

    @Override
    public void close() {
    }
}

