/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import java.nio.ByteBuffer;

public class FilteredBufferAggregator
implements BufferAggregator {
    private final ValueMatcher matcher;
    private final BufferAggregator delegate;

    public FilteredBufferAggregator(ValueMatcher matcher, BufferAggregator delegate) {
        this.matcher = matcher;
        this.delegate = delegate;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        this.delegate.init(buf, position);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        if (this.matcher.matches()) {
            this.delegate.aggregate(buf, position);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return this.delegate.get(buf, position);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return this.delegate.getLong(buf, position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return this.delegate.getFloat(buf, position);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return this.delegate.getDouble(buf, position);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("matcher", this.matcher);
        inspector.visit("delegate", this.delegate);
    }
}

