/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.query.aggregation.AggregateCombiner;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.FilteredAggregator;
import io.druid.query.aggregation.FilteredBufferAggregator;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.ValueMatcher;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.filter.Filters;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;

public class FilteredAggregatorFactory
extends AggregatorFactory {
    private final AggregatorFactory delegate;
    private final DimFilter filter;

    public FilteredAggregatorFactory(@JsonProperty(value="aggregator") AggregatorFactory delegate, @JsonProperty(value="filter") DimFilter filter) {
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)filter);
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        ValueMatcher valueMatcher = Filters.toFilter(this.filter).makeMatcher(columnSelectorFactory);
        return new FilteredAggregator(valueMatcher, this.delegate.factorize(columnSelectorFactory));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        ValueMatcher valueMatcher = Filters.toFilter(this.filter).makeMatcher(columnSelectorFactory);
        return new FilteredBufferAggregator(valueMatcher, this.delegate.factorizeBuffered(columnSelectorFactory));
    }

    @Override
    public Comparator getComparator() {
        return this.delegate.getComparator();
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return this.delegate.combine(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return this.delegate.makeAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return this.delegate.getCombiningFactory();
    }

    @Override
    public Object deserialize(Object object) {
        return this.delegate.deserialize(object);
    }

    @Override
    public Object finalizeComputation(Object object) {
        return this.delegate.finalizeComputation(object);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public List<String> requiredFields() {
        return this.delegate.requiredFields();
    }

    public byte[] getCacheKey() {
        byte[] filterCacheKey = this.filter.getCacheKey();
        byte[] aggregatorCacheKey = this.delegate.getCacheKey();
        return ByteBuffer.allocate(1 + filterCacheKey.length + aggregatorCacheKey.length).put((byte)9).put(filterCacheKey).put(aggregatorCacheKey).array();
    }

    @Override
    public String getTypeName() {
        return this.delegate.getTypeName();
    }

    @Override
    public int getMaxIntermediateSize() {
        return this.delegate.getMaxIntermediateSize();
    }

    @JsonProperty
    public AggregatorFactory getAggregator() {
        return this.delegate;
    }

    @JsonProperty
    public DimFilter getFilter() {
        return this.filter;
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return this.delegate.getRequiredColumns();
    }

    public String toString() {
        return "FilteredAggregatorFactory{delegate=" + this.delegate + ", filter=" + this.filter + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredAggregatorFactory that = (FilteredAggregatorFactory)o;
        if (this.delegate != null ? !this.delegate.equals(that.delegate) : that.delegate != null) {
            return false;
        }
        return !(this.filter != null ? !this.filter.equals(that.filter) : that.filter != null);
    }

    public int hashCode() {
        int result = this.delegate != null ? this.delegate.hashCode() : 0;
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }
}

