/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.SimpleDoubleBufferAggregator;
import io.druid.segment.BaseDoubleColumnValueSelector;
import java.nio.ByteBuffer;

public class DoubleMaxBufferAggregator
extends SimpleDoubleBufferAggregator {
    DoubleMaxBufferAggregator(BaseDoubleColumnValueSelector selector) {
        super(selector);
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putDouble(position, Double.NEGATIVE_INFINITY);
    }

    @Override
    public void putFirst(ByteBuffer buf, int position, double value) {
        if (!Double.isNaN(value)) {
            buf.putDouble(position, value);
        } else {
            this.init(buf, position);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, double value) {
        buf.putDouble(position, Math.max(buf.getDouble(position), value));
    }
}

