/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.druid.query.aggregation.AggregateCombiner;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.CountAggregator;
import io.druid.query.aggregation.CountBufferAggregator;
import io.druid.query.aggregation.LongSumAggregateCombiner;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.segment.ColumnSelectorFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class CountAggregatorFactory
extends AggregatorFactory {
    private final String name;

    @JsonCreator
    public CountAggregatorFactory(@JsonProperty(value="name") String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        this.name = name;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new CountAggregator();
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new CountBufferAggregator();
    }

    @Override
    public Comparator getComparator() {
        return CountAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return CountAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new LongSumAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new LongSumAggregatorFactory(this.name, this.name);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new CountAggregatorFactory(this.name));
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return ImmutableList.of();
    }

    public byte[] getCacheKey() {
        return new byte[]{0};
    }

    @Override
    public String getTypeName() {
        return "long";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    public String toString() {
        return "CountAggregatorFactory{name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountAggregatorFactory that = (CountAggregatorFactory)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

