/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.LongSumAggregator;
import java.util.Comparator;

public class CountAggregator
implements Aggregator {
    static final Comparator COMPARATOR = LongSumAggregator.COMPARATOR;
    private long count = 0L;

    static Object combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).longValue() + ((Number)rhs).longValue();
    }

    @Override
    public void aggregate() {
        ++this.count;
    }

    @Override
    public Object get() {
        return this.count;
    }

    @Override
    public float getFloat() {
        return this.count;
    }

    @Override
    public long getLong() {
        return this.count;
    }

    @Override
    public double getDouble() {
        return this.count;
    }

    public Aggregator clone() {
        return new CountAggregator();
    }

    @Override
    public void close() {
    }
}

