/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Lists;
import io.druid.java.util.common.Pair;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprMacroTable;
import io.druid.math.expr.Parser;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.BaseDoubleColumnValueSelector;
import io.druid.segment.BaseFloatColumnValueSelector;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DoubleColumnSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.virtual.ExpressionSelectors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class AggregatorUtil {
    public static final byte STRING_SEPARATOR = -1;
    public static final byte COUNT_CACHE_TYPE_ID = 0;
    public static final byte LONG_SUM_CACHE_TYPE_ID = 1;
    public static final byte DOUBLE_SUM_CACHE_TYPE_ID = 2;
    public static final byte DOUBLE_MAX_CACHE_TYPE_ID = 3;
    public static final byte DOUBLE_MIN_CACHE_TYPE_ID = 4;
    public static final byte HYPER_UNIQUE_CACHE_TYPE_ID = 5;
    public static final byte JS_CACHE_TYPE_ID = 6;
    public static final byte HIST_CACHE_TYPE_ID = 7;
    public static final byte CARD_CACHE_TYPE_ID = 8;
    public static final byte FILTERED_AGG_CACHE_TYPE_ID = 9;
    public static final byte LONG_MAX_CACHE_TYPE_ID = 10;
    public static final byte LONG_MIN_CACHE_TYPE_ID = 11;
    public static final byte FLOAT_SUM_CACHE_TYPE_ID = 12;
    public static final byte FLOAT_MAX_CACHE_TYPE_ID = 13;
    public static final byte FLOAT_MIN_CACHE_TYPE_ID = 14;
    public static final byte SKETCH_MERGE_CACHE_TYPE_ID = 15;
    public static final byte DISTINCT_COUNT_CACHE_KEY = 16;
    public static final byte FLOAT_LAST_CACHE_TYPE_ID = 17;
    public static final byte APPROX_HIST_CACHE_TYPE_ID = 18;
    public static final byte APPROX_HIST_FOLDING_CACHE_TYPE_ID = 19;
    public static final byte DOUBLE_FIRST_CACHE_TYPE_ID = 20;
    public static final byte DOUBLE_LAST_CACHE_TYPE_ID = 21;
    public static final byte FLOAT_FIRST_CACHE_TYPE_ID = 22;
    public static final byte LONG_FIRST_CACHE_TYPE_ID = 23;
    public static final byte LONG_LAST_CACHE_TYPE_ID = 24;
    public static final byte TIMESTAMP_CACHE_TYPE_ID = 25;
    public static final byte VARIANCE_CACHE_TYPE_ID = 26;
    public static final byte QUANTILES_DOUBLES_SKETCH_BUILD_CACHE_TYPE_ID = 27;
    public static final byte QUANTILES_DOUBLES_SKETCH_MERGE_CACHE_TYPE_ID = 28;
    public static final byte QUANTILES_DOUBLES_SKETCH_TO_HISTOGRAM_CACHE_TYPE_ID = 29;
    public static final byte QUANTILES_DOUBLES_SKETCH_TO_QUANTILE_CACHE_TYPE_ID = 30;
    public static final byte QUANTILES_DOUBLES_SKETCH_TO_QUANTILES_CACHE_TYPE_ID = 31;
    public static final byte QUANTILES_DOUBLES_SKETCH_TO_STRING_CACHE_TYPE_ID = 32;

    public static List<PostAggregator> pruneDependentPostAgg(List<PostAggregator> postAggregatorList, String postAggName) {
        LinkedList rv = Lists.newLinkedList();
        HashSet<String> deps = new HashSet<String>();
        deps.add(postAggName);
        for (PostAggregator agg : Lists.reverse(postAggregatorList)) {
            if (!deps.contains(agg.getName())) continue;
            rv.addFirst(agg);
            deps.remove(agg.getName());
            deps.addAll(agg.getDependentFields());
        }
        return rv;
    }

    public static Pair<List<AggregatorFactory>, List<PostAggregator>> condensedAggregators(List<AggregatorFactory> aggList, List<PostAggregator> postAggList, String metric) {
        List<PostAggregator> condensedPostAggs = AggregatorUtil.pruneDependentPostAgg(postAggList, metric);
        HashSet<String> dependencySet = new HashSet<String>();
        dependencySet.add(metric);
        for (PostAggregator postAggregator : condensedPostAggs) {
            dependencySet.addAll(postAggregator.getDependentFields());
        }
        ArrayList condensedAggs = Lists.newArrayList();
        for (AggregatorFactory aggregatorSpec : aggList) {
            if (!dependencySet.contains(aggregatorSpec.getName())) continue;
            condensedAggs.add(aggregatorSpec);
        }
        return new Pair((Object)condensedAggs, condensedPostAggs);
    }

    public static BaseFloatColumnValueSelector makeColumnValueSelectorWithFloatDefault(ColumnSelectorFactory metricFactory, ExprMacroTable macroTable, String fieldName, String fieldExpression, final float nullValue) {
        if (fieldName != null && fieldExpression == null) {
            return metricFactory.makeColumnValueSelector(fieldName);
        }
        if (fieldName == null && fieldExpression != null) {
            Expr expr = Parser.parse((String)fieldExpression, (ExprMacroTable)macroTable);
            final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(metricFactory, expr);
            class ExpressionFloatColumnSelector
            implements FloatColumnSelector {
                ExpressionFloatColumnSelector() {
                }

                @Override
                public float getFloat() {
                    ExprEval exprEval = (ExprEval)baseSelector.getObject();
                    return exprEval.isNull() ? nullValue : (float)exprEval.asDouble();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", baseSelector);
                }
            }
            return new ExpressionFloatColumnSelector();
        }
        throw new IllegalArgumentException("Must have a valid, non-null fieldName or expression");
    }

    public static BaseLongColumnValueSelector makeColumnValueSelectorWithLongDefault(ColumnSelectorFactory metricFactory, ExprMacroTable macroTable, String fieldName, String fieldExpression, final long nullValue) {
        if (fieldName != null && fieldExpression == null) {
            return metricFactory.makeColumnValueSelector(fieldName);
        }
        if (fieldName == null && fieldExpression != null) {
            Expr expr = Parser.parse((String)fieldExpression, (ExprMacroTable)macroTable);
            final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(metricFactory, expr);
            class ExpressionLongColumnSelector
            implements LongColumnSelector {
                ExpressionLongColumnSelector() {
                }

                @Override
                public long getLong() {
                    ExprEval exprEval = (ExprEval)baseSelector.getObject();
                    return exprEval.isNull() ? nullValue : exprEval.asLong();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", baseSelector);
                }
            }
            return new ExpressionLongColumnSelector();
        }
        throw new IllegalArgumentException("Must have a valid, non-null fieldName or expression");
    }

    public static BaseDoubleColumnValueSelector makeColumnValueSelectorWithDoubleDefault(ColumnSelectorFactory metricFactory, ExprMacroTable macroTable, String fieldName, String fieldExpression, final double nullValue) {
        if (fieldName != null && fieldExpression == null) {
            return metricFactory.makeColumnValueSelector(fieldName);
        }
        if (fieldName == null && fieldExpression != null) {
            Expr expr = Parser.parse((String)fieldExpression, (ExprMacroTable)macroTable);
            final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(metricFactory, expr);
            class ExpressionDoubleColumnSelector
            implements DoubleColumnSelector {
                ExpressionDoubleColumnSelector() {
                }

                @Override
                public double getDouble() {
                    ExprEval exprEval = (ExprEval)baseSelector.getObject();
                    return exprEval.isNull() ? nullValue : exprEval.asDouble();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", baseSelector);
                }
            }
            return new ExpressionDoubleColumnSelector();
        }
        throw new IllegalArgumentException("Must have a valid, non-null fieldName or expression");
    }
}

