/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.java.util.common.Cacheable;
import io.druid.java.util.common.UOE;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.aggregation.AggregateCombiner;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AggregatorFactory
implements Cacheable {
    private static final Logger log = new Logger(AggregatorFactory.class);

    public abstract Aggregator factorize(ColumnSelectorFactory var1);

    public abstract BufferAggregator factorizeBuffered(ColumnSelectorFactory var1);

    public abstract Comparator getComparator();

    public abstract Object combine(Object var1, Object var2);

    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("[%s] does not implement makeAggregateCombiner()", new Object[]{this.getClass().getName()});
    }

    public abstract AggregatorFactory getCombiningFactory();

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        AggregatorFactory combiningFactory = this.getCombiningFactory();
        if (other.getName().equals(this.getName()) && combiningFactory.equals(other.getCombiningFactory())) {
            return combiningFactory;
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    public abstract List<AggregatorFactory> getRequiredColumns();

    public abstract Object deserialize(Object var1);

    public abstract Object finalizeComputation(Object var1);

    public abstract String getName();

    public abstract List<String> requiredFields();

    public abstract String getTypeName();

    public abstract int getMaxIntermediateSize();

    @Nullable
    public static AggregatorFactory[] mergeAggregators(List<AggregatorFactory[]> aggregatorsList) {
        if (aggregatorsList == null || aggregatorsList.isEmpty()) {
            return null;
        }
        if (aggregatorsList.size() == 1) {
            AggregatorFactory[] aggregatorFactories = aggregatorsList.get(0);
            if (aggregatorFactories != null) {
                AggregatorFactory[] combiningFactories = new AggregatorFactory[aggregatorFactories.length];
                Arrays.setAll(combiningFactories, i -> aggregatorFactories[i].getCombiningFactory());
                return combiningFactories;
            }
            return null;
        }
        LinkedHashMap<String, AggregatorFactory> mergedAggregators = new LinkedHashMap<String, AggregatorFactory>();
        block2: for (AggregatorFactory[] aggregators : aggregatorsList) {
            if (aggregators != null) {
                for (AggregatorFactory aggregator : aggregators) {
                    String name = aggregator.getName();
                    if (mergedAggregators.containsKey(name)) {
                        AggregatorFactory other = (AggregatorFactory)mergedAggregators.get(name);
                        try {
                            mergedAggregators.put(name, aggregator.getMergingFactory(other));
                            continue;
                        }
                        catch (AggregatorFactoryNotMergeableException ex) {
                            log.warn((Throwable)ex, "failed to merge aggregator factories", new Object[0]);
                            mergedAggregators = null;
                            continue block2;
                        }
                    }
                    mergedAggregators.put(name, aggregator);
                }
                continue;
            }
            mergedAggregators = null;
            break;
        }
        return mergedAggregators == null ? null : mergedAggregators.values().toArray(new AggregatorFactory[mergedAggregators.size()]);
    }
}

