/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.druid.java.util.common.guava.MergeSequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.UnionDataSource;
import java.util.Map;

public class UnionQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public UnionQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    @Override
    public Sequence<T> run(final QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final Query<T> query = queryPlus.getQuery();
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof UnionDataSource) {
            return new MergeSequence(query.getResultOrdering(), Sequences.simple((Iterable)Lists.transform(((UnionDataSource)dataSource).getDataSources(), (Function)new Function<DataSource, Sequence<T>>(){

                public Sequence<T> apply(DataSource singleSource) {
                    return UnionQueryRunner.this.baseRunner.run(queryPlus.withQuery(query.withDataSource(singleSource)), responseContext);
                }
            })));
        }
        return this.baseRunner.run(queryPlus, responseContext);
    }
}

