/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.query.Result;
import java.util.Comparator;

public class ResultGranularTimestampComparator<T>
implements Comparator<Result<T>> {
    private final Granularity gran;

    public ResultGranularTimestampComparator(Granularity granularity) {
        this.gran = granularity;
    }

    @Override
    public int compare(Result<T> r1, Result<T> r2) {
        return Longs.compare((long)this.gran.bucketStart(r1.getTimestamp()).getMillis(), (long)this.gran.bucketStart(r2.getTimestamp()).getMillis());
    }

    public static <T> Ordering<Result<T>> create(Granularity granularity, boolean descending) {
        ResultGranularTimestampComparator<T> comparator = new ResultGranularTimestampComparator<T>(granularity);
        return descending ? Ordering.from(comparator).reverse() : Ordering.from(comparator);
    }
}

