/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Lists;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.SegmentDescriptor;
import java.util.List;
import java.util.Map;

public class ReportTimelineMissingSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final SegmentDescriptor descriptor;

    public ReportTimelineMissingSegmentQueryRunner(SegmentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        List missingSegments = (List)responseContext.get(Result.MISSING_SEGMENTS_KEY);
        if (missingSegments == null) {
            missingSegments = Lists.newArrayList();
            responseContext.put(Result.MISSING_SEGMENTS_KEY, missingSegments);
        }
        missingSegments.add(this.descriptor);
        return Sequences.empty();
    }
}

