/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.ReportTimelineMissingSegmentQueryRunner;
import io.druid.query.SegmentDescriptor;
import io.druid.segment.ReferenceCountingSegment;
import java.io.Closeable;
import java.util.Map;

public class ReferenceCountingSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunnerFactory<T, Query<T>> factory;
    private final ReferenceCountingSegment adapter;
    private final SegmentDescriptor descriptor;

    public ReferenceCountingSegmentQueryRunner(QueryRunnerFactory<T, Query<T>> factory, ReferenceCountingSegment adapter, SegmentDescriptor descriptor) {
        this.factory = factory;
        this.adapter = adapter;
        this.descriptor = descriptor;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        if (this.adapter.increment()) {
            try {
                Sequence<T> baseSequence = this.factory.createRunner(this.adapter).run(queryPlus, responseContext);
                return Sequences.withBaggage(baseSequence, (Closeable)this.adapter.decrementOnceCloseable());
            }
            catch (Throwable t) {
                try {
                    this.adapter.decrement();
                }
                catch (Exception e) {
                    t.addSuppressed(e);
                }
                throw t;
            }
        }
        return new ReportTimelineMissingSegmentQueryRunner<T>(this.descriptor).run(queryPlus, responseContext);
    }
}

