/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.filter.Filter;
import io.druid.segment.Cursor;
import io.druid.segment.StorageAdapter;
import io.druid.segment.VirtualColumns;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.joda.time.Interval;

public class QueryRunnerHelper {
    public static <T> Sequence<Result<T>> makeCursorBasedQuery(StorageAdapter adapter, List<Interval> queryIntervals, Filter filter, VirtualColumns virtualColumns, boolean descending, Granularity granularity, final Function<Cursor, Result<T>> mapFn) {
        Preconditions.checkArgument((queryIntervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{queryIntervals});
        return Sequences.filter((Sequence)Sequences.map(adapter.makeCursors(filter, queryIntervals.get(0), virtualColumns, granularity, descending, null), (Function)new Function<Cursor, Result<T>>(){

            public Result<T> apply(Cursor input) {
                return (Result)mapFn.apply((Object)input);
            }
        }), (Predicate)Predicates.notNull());
    }

    public static <T> QueryRunner<T> makeClosingQueryRunner(final QueryRunner<T> runner, final Closeable closeable) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
                return Sequences.withBaggage(runner.run(queryPlus, responseContext), (Closeable)closeable);
            }
        };
    }
}

