/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Preconditions;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.Query;
import io.druid.query.QueryMetrics;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChest;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.Map;
import javax.annotation.Nullable;

public final class QueryPlus<T> {
    private final Query<T> query;
    private final QueryMetrics<?> queryMetrics;

    public static <T> QueryPlus<T> wrap(Query<T> query) {
        Preconditions.checkNotNull(query);
        return new QueryPlus<T>(query, null);
    }

    private QueryPlus(Query<T> query, QueryMetrics<?> queryMetrics) {
        this.query = query;
        this.queryMetrics = queryMetrics;
    }

    public Query<T> getQuery() {
        return this.query;
    }

    @Nullable
    public QueryMetrics<?> getQueryMetrics() {
        return this.queryMetrics;
    }

    public QueryPlus<T> withQueryMetrics(QueryToolChest<T, ? extends Query<T>> queryToolChest) {
        if (this.queryMetrics != null) {
            return this;
        }
        return new QueryPlus<T>(this.query, queryToolChest.makeMetrics(this.query));
    }

    public QueryPlus<T> withoutThreadUnsafeState() {
        return this.withoutQueryMetrics();
    }

    private QueryPlus<T> withoutQueryMetrics() {
        if (this.queryMetrics == null) {
            return this;
        }
        return new QueryPlus<T>(this.query, null);
    }

    public QueryPlus<T> withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new QueryPlus<T>(this.query.withQuerySegmentSpec(spec), this.queryMetrics);
    }

    public <U> QueryPlus<U> withQuery(Query<U> replacementQuery) {
        return new QueryPlus<U>(replacementQuery, this.queryMetrics);
    }

    public Sequence<T> run(QuerySegmentWalker walker, Map<String, Object> context) {
        return this.query.getRunner(walker).run(this, context);
    }
}

